@extends('layouts.admin')

@section('title', 'Dashboard')

@section('content')
<h1 class="h3 mb-4">Dashboard</h1>

<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Total Doctors</h5>
                <h2 class="mb-0">{{ $stats['total_doctors'] }}</h2>
                <small class="text-muted">{{ $stats['active_doctors'] }} active</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Total Services</h5>
                <h2 class="mb-0">{{ $stats['total_services'] }}</h2>
                <small class="text-muted">{{ $stats['active_services'] }} active</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Appointments</h5>
                <h2 class="mb-0">{{ $stats['total_appointments'] }}</h2>
                <small class="text-muted">{{ $stats['pending_appointments'] }} pending</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Unread Messages</h5>
                <h2 class="mb-0">{{ $stats['unread_messages'] }}</h2>
            </div>
        </div>
    </div>
</div>

<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Blog Posts</h5>
                <h2 class="mb-0">{{ $stats['total_blogs'] }}</h2>
                <small class="text-muted">{{ $stats['published_blogs'] }} published</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Testimonials</h5>
                <h2 class="mb-0">{{ $stats['total_testimonials'] }}</h2>
                <small class="text-muted">{{ $stats['active_testimonials'] }} active</small>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Recent Appointments</h5>
    </div>
    <div class="card-body">
        @if($recentAppointments->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Patient Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Preferred Time</th>
                        <th>Doctor</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recentAppointments as $appointment)
                    <tr>
                        <td>{{ $appointment->name }}</td>
                        <td>{{ $appointment->email }}</td>
                        <td>{{ $appointment->phone }}</td>
                        <td>{{ $appointment->preferred_time->format('M d, Y h:i A') }}</td>
                        <td>{{ $appointment->doctor ? $appointment->doctor->name : 'Any Doctor' }}</td>
                        <td>
                            <span class="badge bg-{{ $appointment->status == 'pending' ? 'warning' : ($appointment->status == 'confirmed' ? 'success' : 'danger') }}">
                                {{ ucfirst($appointment->status) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('admin.appointments.show', $appointment) }}" class="btn btn-sm btn-primary">
                                <i class="bi bi-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <p class="text-muted mb-0">No appointments yet.</p>
        @endif
    </div>
</div>
@endsection

